﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4000 = {
    //general options and settings
    opts: {
        questions: {
            _qTID3QID7: function () {
                return $('div[id$="TID3_QID7"]');
            },
            _qTID3QID8: function () {
                return $('div[id$="TID3_QID8"]');
            }
        },
        responses: {
            _rTID3QID7: function () {
                return $('input[type="radio"]', $('div[id$="TID3_QID7"]'));
            },
            _rTID3QID8: function () {
                return $('input[type="radio"]', $('div[id$="TID3_QID8"]'));
            },
            _rTID3QID7_t99: function () {
                return $('input[type="checkbox"]', $('div[id$="TID3_QID7"]'));
            },
            _rTID3QID8_t99: function () {
                return $('input[type="checkbox"]', $('div[id$="TID3_QID8"]'));
            }
        }
    },

    //clear question responses
    clearQuestionResp: function (qid) {
        if (typeof (qid) === "object") {
            $('input[type="radio"]', $(qid)).attr('checked', false).attr('disabled', true);
            if (!$(qid).hasClass('disabled')) {
                $(qid).addClass('disabled');
            }
        }
    },

    //bind responses click event
    bindResponseClick: function () {
        var _me = this;
        $.each(_me.opts.responses._rTID3QID7(), function (i, ele) {
            $(ele).bind({
                click: function (e) {
                    $(_me.opts.questions._qTID3QID7()).removeClass('disabled');
                    _me.clearQuestionResp(_me.opts.questions._qTID3QID8());
                    $(_me.opts.responses._rTID3QID8_t99()).attr('disabled', true);
                }
            });
        });

        $.each(_me.opts.responses._rTID3QID8(), function (i, ele) {
            $(ele).bind({
                click: function (e) {
                    $(_me.opts.questions._qTID3QID8()).removeClass('disabled');
                    _me.clearQuestionResp(_me.opts.questions._qTID3QID7());
                    $(_me.opts.responses._rTID3QID7_t99()).attr('disabled', true);
                }
            });
        });

        $.each(_me.opts.responses._rTID3QID7_t99(), function (i, ele) {
            $(ele).bind({
                click: function () {

                    $(_me.opts.questions._qTID3QID8()).removeClass('disabled');
                    $(_me.opts.responses._rTID3QID8()).attr('checked', false).attr('disabled', false);
                    $(_me.opts.responses._rTID3QID8_t99()).attr('checked', false).attr('disabled', false);

                    if (this.checked) {
                        _me.clearQuestionResp(_me.opts.questions._qTID3QID7());
                        $(this).attr('disabled', true);
                    }
                }
            });
        });

        $.each(_me.opts.responses._rTID3QID8_t99(), function (i, ele) {
            $(ele).bind({
                click: function () {

                    $(_me.opts.questions._qTID3QID7()).removeClass('disabled');
                    $(_me.opts.responses._rTID3QID7()).attr('checked', false).attr('disabled', false);
                    $(_me.opts.responses._rTID3QID7_t99()).attr('checked', false).attr('disabled', false);

                    if (this.checked) {
                        _me.clearQuestionResp(_me.opts.questions._qTID3QID8());
                        $(this).attr('disabled', true);
                    }
                }
            });
        });

    },
    
    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //call functions here
                    _me.bindResponseClick();

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 1);
            });
        });
    }
};